<?php
/*--------------------------------------------------------------
   move.php 2022-12-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/
/** @var DatabaseModel $this */

$move = [];

// checks if the paypal3 module is being used by the shop, if yes it will be replaced from the update directory
$result = $this->query("SELECT `key` FROM `gx_configurations` WHERE `key` = 'configuration/MODULE_PAYMENT_INSTALLED' AND `value` LIKE '%paypal3.php%';",
                       true);
if ($result->num_rows === 1) {
    $source         = 'gambio_updater/updates/v4.7.2.0/move/paypal3.php';
    $destination    = 'includes/modules/payment/paypal3.php';
    $copySuccessful = false;
    
    // try to copy first
    if (is_writeable(DIR_FS_CATALOG . 'includes/modules/payment') && file_exists(DIR_FS_CATALOG . $source)) {
        if (file_exists(DIR_FS_CATALOG . $destination)) {
            rename(DIR_FS_CATALOG . $destination, DIR_FS_CATALOG . $destination . '.' . date('YmdHis') . '.bak');
        }
        
        $copySuccessful = copy(DIR_FS_CATALOG . $source, DIR_FS_CATALOG . $destination);
        chmod(DIR_FS_CATALOG . $destination, 0777);
    }
    
    if (!$copySuccessful) {
        $move[$source] = $destination;
    }
}

return $move;